<html>
<head>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
    <style>

        img {

            border: 3px solid #000;

        }

    </style>
</head>
<body class="p-4">
<div id="app" class="container">
    <!-- 画像を選択する部分 -->
    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label>gifアニメにする画像を選んでください（複数）</label>
                <input class="form-control" type="file" accept="image/*" multiple @change="onFileChange">
            </div>
        </div>
    </div>
    <!-- 選択された画像のプレビュー部分 -->
    <div class="row">
        <div class="col-4 p-3" v-for="(image,index) in images">
            <div>
                <span v-text="(index+1)"></span>コマ目
            </div>
            <img class="img-fluid" :src="image.data">
        </div>
    </div>
    <!-- 画像が選択されたら表示される部分 -->
    <div class="row" v-if="images.length">
        <div class="col-12 pt-4">
            <button class="btn btn-primary" type="button" @click="onSubmit">画像をアップロードする</button>
        </div>
    </div>
    <!-- gifアニメが完成したら表示される部分 -->
    <div v-if="gifUrl" class="pt-4">
        <img :src="gifUrl">
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/vue@2.6.0"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.0/axios.min.js"></script>
<script>

    new Vue({
        el: '#app',
        data: {
            images: [],
            gifUrl: ''
        },
        methods: {
            onFileChange(e) {

                this.images = [];
                const files = e.target.files;
                let promises = [];

                [].forEach.call(files, file => {    // 選択された画像をループ

                    let promise = new Promise(resolve => {

                        const reader = new FileReader();
                        reader.onload = e => {

                            const imageData = e.target.result;

                            // Promiseに画像データを返す
                            resolve({
                                file: file,
                                data: imageData
                            });

                        };
                        reader.readAsDataURL(file);

                    });
                    promises.push(promise);

                });

                Promise.all(promises).then(images => {

                    // ファイル名で並び替え
                    images.sort((a, b) => (a.file.name > b.file.name) ? 1 : -1);
                    this.images = images;

                });

            },
            onSubmit() {

                const url = '/animated_gif';
                let formData = new FormData();

                this.images.forEach(image => {

                    formData.append('images[]', image.file);

                });

                axios.post(url, formData)
                    .then(response => {

                        if(response.data.result) {

                            this.gifUrl = response.data.gif_url;

                        }

                    });

            }
        }
    });

</script>
</body>
</html>
